package editor;

import game.CustomImageDataII;
import game.IntRect;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.image.ImageObserver;
import java.io.BufferedWriter;

public class ConveyorScreenObject extends ScreenObject  implements CloneableScreenObject{
	
	private boolean isSelected = false;
	private ConveyorPaletteObject paletteObject;
	private IntRect clickRect;
	
	@Override
	public void draw(Graphics g) {
		
		CustomImageDataII cid = paletteObject.getImage();
		cid.drawObjectFromUpperLeftCorner(g, clickRect.getMinX(), clickRect.getMinY());
		

		if(isSelected()) {
			drawSelectionOverObject(g);
		}
		
	}

	@Override
	public IntRect getClickRect() {
		return clickRect;
	}

	@Override
	public void setClickRect(IntRect newRect) {
		clickRect = newRect;
	}

	@Override
	public void setSelected(boolean is) {
		isSelected = is;
	}

	@Override
	public boolean isSelected() {
		return isSelected;
	}
	
	public ConveyorScreenObject(int x, int y, ConveyorPaletteObject thePaletteObject) {
		
		paletteObject = thePaletteObject;
		
		int width = paletteObject.getImage().getDesiredWidth();
		int height = paletteObject.getImage().getDesiredHeight();
		
		isSelected = false;
		clickRect = new IntRect(x - width/2, y - height/2, width, height);
	}
	
	
	public void changeSize(int newWidth, int newHeight) {
		
		Point centerPoint = clickRect.getCenter();
		
		int newMinX = centerPoint.x - newWidth/2;
		int newMinY = centerPoint.y - newWidth/2;
		
		clickRect = new IntRect(newMinX, newMinY, newWidth, newHeight);
		
	}
	
	
	
	
	

	public void writeOutToFile(BufferedWriter out) throws Exception{
		
		out.write("conveyor:");
		out.newLine();
		
		Point centerPoint = clickRect.getCenter();
		
		out.write("x:");
		out.write(Integer.toString(centerPoint.x));
		out.newLine();
		
		out.write("y:");
		out.write(Integer.toString(centerPoint.y));
		out.newLine();
		
		out.write("width:");
		out.write(Integer.toString(this.getClickRect().width()));
		out.newLine();
		
		out.write("height:");
		out.write(Integer.toString(this.getClickRect().height()));
		out.newLine();
		
		
		
		if(this.paletteObject.isPassThru()) {
			out.write("passThru");
		} else {
			out.write("solid");
		}
		out.newLine();
		
		out.write("dir:");
		if(paletteObject.isGoingLeft()) {
			out.write("l");
		} else {
			out.write("r");
		}
		out.newLine();
		
		out.write("speed:");
		out.write(Integer.toString(paletteObject.getSpeed()));
		out.newLine();
		//CustomAnimationPanel.convertColorToString(paletteObject.getImage().getTransparentColor())
		
		
		CustomImageDataII imArr[] = paletteObject.getAnimation();
		
		out.write("frameCount:");
		out.write(Integer.toString(imArr.length));
		out.newLine();
		
		for(CustomImageDataII cid : imArr) {
			out.write(cid.getFileName());
			out.write("*");
			out.write(CustomAnimationPanel.convertColorToString(cid.getTransparentColor()));
			out.newLine();
		}
		
		
		out.write("/block");
		out.newLine();
		
		out.newLine();
	}
	

	
	public ConveyorScreenObject clone(ImageObserver io) {
		
		Point centerPoint = clickRect.getCenter();
		
		ConveyorScreenObject returnValue = new ConveyorScreenObject(centerPoint.x, centerPoint.y, this.paletteObject);
		
		return returnValue;
		
	}

	@Override
	public int getLayer() {
		return 7;
	}
	
	
}
